package com.ejie.ab04b.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.nora.LocalidadDao;
import com.ejie.ab04b.model.nora.Localidad;

/**
 * LocalidadServiceImpl.
 * 
 * @author GFI
 */
@Service(value = "localidadService")
public class LocalidadServiceImpl implements LocalidadService {

	@Autowired()
	private LocalidadDao localidadDao;

	/**
	 * Finds a single row in the Localidad table.
	 * 
	 * localidad Localidad Localidad
	 *
	 * @param localidad
	 *            the localidad
	 * @return the localidad
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Localidad find(Localidad localidad) {
		return (Localidad) this.localidadDao.find(localidad);
	}

	/**
	 * Finds a List of rows in the Localidad table.
	 * 
	 * localidad Localidad List
	 *
	 * @param localidad
	 *            the localidad
	 * @return the list
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public List<Localidad> findAll(Localidad localidad) {
		return (List<Localidad>) this.localidadDao.findAll(localidad);
	}

	/**
	 * Counts rows in the Localidad table.
	 * 
	 * localidad Localidad Long
	 *
	 * @param localidad
	 *            the localidad
	 * @return the long
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Long findAllCount(Localidad localidad) {
		return this.localidadDao.findAllCount(localidad);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.nora.LocalidadService#findAllFirst(com.ejie.ab04b.
	 * model.nora.Localidad)
	 */
	@Override()
	public Localidad findAllFirst(Localidad localidad) {
		return this.localidadDao.findAllFirst(localidad);
	}
}